const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  var seq = sequelize.define('tbl_temp_mastergroup', {
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    MstSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    WgmtModeNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    ProductType: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    }, 
    Area: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    CubicalNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    CubicleName: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    CubicleType: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    IPQCType: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    CoatingType: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    MachineCode: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    }, 
    Department : {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    BFGCode: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    ProductName: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    PVersion: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Version: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    BatchNo: {
      type: DataTypes.STRING(25),
      allowNull: true,
      defaultValue: "NULL"
    },
    BatchSize: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    BMRNo : {
      type: DataTypes.STRING(150),
      allowNull: true,
      defaultValue: "NULL"
    },  
    GraphType: {
      type: DataTypes.STRING(15),
      allowNull: true,
      defaultValue: "NULL",
      //comment: "0:Standard 1: Average"
    },
    Qty: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    GrpQty: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    GrpFreq: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Idsno: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    BalanceId: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    VernierId: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    FriabilityID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    HardnessID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    UserId: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    PrDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    PrTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    PrEndDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    PrEndTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    Stage: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    SideNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: "0"
    },
    Side: {
      type: DataTypes.STRING(20),
      allowNull: true,
      defaultValue: "NULL"
    },
    Unit: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "NULL"
    },
    DecimalPoint: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    LimitOn: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
      //comment: "0: Actual 1 :Percentage"
    },
    NMT: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Nom: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1NegTol: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1PosTol: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegTol: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosTol: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1NegTolActual: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1PosTolActual: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegTolActual: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosTolActual: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    NomEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1NegEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1PosEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    NomNet: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1NegNet: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1PosNet: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegNet: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosNet: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1NegNetActual: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1PosNetActual: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegNetActual: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosNetActual: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    ReportType: {
      type: DataTypes.STRING(5),
      allowNull: true,
      defaultValue: "NULL",
      //comment: "0:Regular 1: Initial"
    },
    PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    IsArchived: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    BatchComplete: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    CheckedByID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    CheckedByName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    CheckedByDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    Lot: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    NoOfAbove1: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: "0"
    },
    NoOfAbove2: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: "0"
    },
    NoOfBelow1: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: "0"
    },
    NoOfBelow2: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: "0"
    },
    MinPer: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    MaxPer: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    MinGrpWeight: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    MaxGrpWeight: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    AvgGrpWeight: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    GroupWeight: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    AvgWeight: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    AvgEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    AvgNet: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    MinWeight: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    MaxWeight: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    MinWeightEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    MaxWeightEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    MinWeightNet: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    MaxWeightNet: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },      
    StdDev: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    }, 
    Remark: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    FailedRemark: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL",
      //comment: "Software"
    },
    FailedRemarkTSH: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL",
      //comment: "Interface"
    },
    Inprocess: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Layer: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL",
      //comment: "Interface"
    },
    LayerName: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL",
      //comment: "Interface"
    },
    HMIID: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Nom_stdtarget: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL",
    },
    TotalWeight: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    StdLimit1: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL",
    },
    StdLimit2: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL",
    },
    Deviation: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL",
    },
    CheckedByTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    Upper_Surface: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL",
    },
    Lower_Surface: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL",
    },
    Appearance_Desc:{
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL",
    },
    Comp_MC_Speed:{
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    Start_Weight:{
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    End_Weight:{
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    Weight_Gain:{
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    Test_Seq: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    MPN_Code: {
      type: DataTypes.STRING(300),
      allowNull: true,
      defaultValue: "NULL"
    },
    ProductCode:{
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    AvgWeightPrewarmed:{
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    Make:{
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    Model:{
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    SerialNo:{
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    SFOID: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NULL"
    },
    TestType:{
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
  }, {
    sequelize,
    tableName: 'tbl_temp_mastergroup',
    timestamps: false,
    // indexes: [
    //   {
    //     name: "PRIMARY",
    //     unique: true,
    //     using: "BTREE",
    //     fields: [
    //       { name: "SrNo" },
    //     ]
    //   },
    //   {
    //     name: "index1",
    //     using: "BTREE",
    //     fields: [
    //       { name: "ProductType" },
    //       { name: "PrDate" },
    //       { name: "ReportType" },
    //     ]
    //   },
    // ]
  });
  seq.removeAttribute('id')
  return seq ;
};
